// Fit power law with Maximum Likelihood (Hill estimator)
// Does not accept covariates. Accepts weights, if and in clauses.
// Threshold() option, if not specified, defaults to sample minimum

cap program drop powerlaw
program define powerlaw, eclass
	version 11.0
	if replay() {
		if "`e(cmd)'" != "powerlaw" error 301
		if _by() error 190
		powerlawDisplay  `0'
		exit 0
	}
	syntax varlist(fv ts numeric max=1) [if] [in] [aw pw fw iw], [THRESHold(string) Level(int $S_level)]
	tempname b V N
	tempvar ldepvar
	marksample touse
	sum `varlist' if `touse', meanonly
	if r(N)==0 {
		di as err "No observations."
		exit 2000
	}
	if `"`threshold'"'=="" {
		local threshold = r(min)
		di as txt _n "Taking sample minimum of " as res r(min) as txt " as the threshold." _n
	}
	else {
		cap confirm scalar `threshold'
		if _rc confirm number `threshold'
		if `threshold' > r(min) {
			qui count if `touse' & `varlist'<`threshold'
			if r(N) {
				di as txt _n `r(N)' " observations below the threshold excluded."
				qui replace `touse' = 0 if `touse' & `varlist'<`threshold'
			}
		}
	}
	if `threshold'<=0 {
		di as err "threshold must be positive"
		exit 198
	}
	local wtype `weight'
	local wtexp `exp'
	if "`wtype'" != "" {
		local wgt [`wtype'`exp']
		local sumwgt [`=cond("`wtype'"=="pweight", "aweight", "`wtype'")'`exp']
	}
	qui gen double `ldepvar' = ln(`varlist') if `touse'
	sum `ldepvar' `sumwgt' if `touse', meanonly
	mat `b' = 1 + 1/(r(mean) - ln(`threshold'))
	mat `V' = (r(N)+1) / (r(N) * (r(mean)-ln(`threshold')))^2 // Newman 2006, eq B10
	mat colnames `b' = alpha:_cons
	mat colnames `V' = alpha:_cons
	mat rownames `V' = alpha:_cons
	ereturn post `b' `V' `wgt', esample(`touse') obs(`r(N)') dof(1)
	ereturn local depvar `varlist'
	ereturn scalar threshold = `threshold'
	ereturn local cmdline `0'
	ereturn local cmd powerlaw
	powerlawDisplay
end

cap program drop powerlawDisplay
program define powerlawDisplay
	version 11.0
	syntax [, Level(int $S_level)]
	di _n as txt "Threshold: " as res %12.8g e(threshold) as txt _col(49) "Number of obs      = " as res %9.0f e(N)
	ereturn display, level(`level')
end
