mata
mata clear
mata set matastrict on
mata set mataoptimize on
mata set matalnum off

void makejive_stata(real scalar jive2, string scalar Xnames, string scalar Z1names, string scalar Z2names, string scalar Wname, string scalar samplename, string scalar IDname, string scalar JIVnames) {
	real matrix X, Z1, Z2, JIV; real colvector ID, W
	pragma unset X; pragma unset Z1; pragma unset Z2; pragma unset W; pragma unset ID; pragma unset JIV
	st_view(Z1 , ., Z1names , samplename) // included exog
	st_view(Z2 , ., Z2names , samplename) // excluded exog
	st_view(X  , ., Xnames  , samplename) // endog
	st_view(ID , ., IDname  , samplename)
	st_view(JIV, ., JIVnames, samplename)
	st_view(W  , ., Wname , samplename)
		
	makejive(jive2, X, Z1, Z2, W, ID, JIV)
}

void makejive(real scalar jive2, real matrix X, real matrix Z1, real matrix Z2, real matrix W, real matrix ID, real matrix JIV) {
	real scalar i, sumW, N; real matrix Z1X, Z1Z1inv, Z2X, Z2Z2inv, Zpihat, H, info, Z2i, Wi
	pragma unset Z2i; pragma unset Wi
	
	N = rows(X)
	if (cols(W)==0) W = 1

	if (cols(Z1)) {
		Z1X     =        quadcross(Z1,W,X )
		Z1Z1inv = invsym(quadcross(Z1,W,Z1))
		X =  X - Z1 * (Z1Z1inv * Z1X) // partial included exogenous variables out of endogenous variables to avoid singleton dummy problem
	}

	Z2X     =        quadcross(Z2,W,X )
	Z2Z2inv = invsym(quadcross(Z2,W,Z2))
	Zpihat = Z2 * (Z2Z2inv * Z2X) // project partialled endogenous variables onto excluded instruments, full-sample

	if (jive2 & rows(W)>1) sumW = quadcolsum(W)

	if (cols(ID)) { // clustered?
		info = panelsetup(ID, 1)
		for (i=rows(info); i; i--) {
			panelsubview(Z2i, Z2 , i, info)
			H = Z2i * Z2Z2inv * Z2i'
			if (rows(W)>1) {
				panelsubview(Wi, W, i, info)
				H = H :* Wi'
			}
			JIV[|info[i,1],.\info[i,2],.|] = (jive2? 1 / (1 - (rows(W)>1? quadcolsum(Wi)/sumW     : rows(Z2i)/N))      :
															                          (rows(W)>1? luinv(I(rows(H)) - H) : invsym(I(rows(H)) - H))
								                       ) * (panelsubmatrix(Zpihat, i, info) - H*panelsubmatrix(X, i, info)) // ~ (Z*pihat - H*X)/(1-H)
		}
	} else {
		H = J(N, 1, .)
		for (i=N; i; i--) {
			Z2i = Z2[i,]
			H[i] = Z2i * Z2Z2inv * Z2i'
		}
		if (rows(W)>1) H = H :* W
		JIV[,] = (Zpihat - H:*X) :/ (1 :- (jive2? (rows(W)>1? W/sumW : 1/N) : H))
	}
}

mata mlib create lmakejive, dir(PLUS) replace
mata mlib add lmakejive *(), dir(PLUS)
mata mlib index
end
