* run after ivregress or ivreg2 to construct JIVE1 instruments
* required option generate() takes name stub to save constructed instrument(s)
* optional option jive2 specifies JIVE2
* optional option EXCLonly specified projecting only onto excluded instruments--useful when included instruments include dummies for clustering groups, which are not all identified in the jackknife subsamples

cap program drop makejive
program define makejive, sortpreserve
	version 11
	syntax [pw iw aw fw/] [if] [in], instd(varlist numeric ts fv) insts(varlist numeric ts fv) GENerate(string) [partial(varlist numeric ts fv) noConstant CLuster(varname) jive2]

	_stubstar2names `generate', nvars(`:word count `instd'')
	local JIVs `s(varlist)'
	qui {
		foreach var in `JIVs' {
			gen double `var' = . in 1
		}

		if "`weight'" != "" {
			cap confirm var `exp'
			if _rc {
				tempname wvar
				gen double `wvar' `exp' `if' `in'
			}
			else local wvar `exp'
		}

		marksample sample

		if "`e(clustvar)'" != "" {
			foreach vars in instd insts partial {
				fvrevar ``vars''
				local `vars' `r(varlist)'
			}
			tempvar ID
			gsort `e(clustvar)', gen(`ID')
		}

		markout `sample' `cluster' `instd' `partial' `insts', strok
		if "`constant'"=="" local cons `sample'
	}
	mata makejive_stata("`jive2'"!="", "`instd'", "`partial'", "`insts' `cons'", "`wvar'", "`sample'", "`ID'", "`JIVs'")
end

