*** IJIVE regressions require that makejive.ado and lmakejive.mlib be in a place visible to Stata, such as C:\ado\plus. 

cd "C:\Users\David\DropBox\Documents\Work\Clients & prospects\GiveWell\Criminal justice\Replications"

set varabbrev off
set showemptycells off
set scheme s1color

* build replication data set
* odbc load, dsn(crime) clear table("Levitt replication")
* saveold "Levitt", replace version(12)
use Levitt, clear
destring income, replace
tsset state year
gen byte litigate = inlist(PostalCode,"AL","AK","AR","DE","FL","MS","NM","OK","RI") | inlist(PostalCode,"SC","TN","TX")
gen str4 label = PostalCode + string(mod(year,100))

* interpolate (non)metropolitan population exponentially
gen double lPopNonmetro = ln(PopNonmetro)
gen double lPopMetro = ln(PopMetro)
by state: ipolate lPopMetro year, gen(temp) epolate
replace PopMetro = exp(temp)
drop temp
by state: ipolate lPopNonmetro year, gen(temp) epolate
replace PopNonmetro = exp(temp)
drop temp
gen double metrop = PopMetro/(PopMetro+PopNonmetro)

* rename replication variables and merge in Levitt-provided data
ren ( income  police  cpi  popul  cri_viol  cri_prop  murder  rape  robbery  assault  burglary  larceny  auto  litigate  black  metrop  unemp  pris_tot  a??_??) ///
    (_income _police _cpi _popul _cri_viol _cri_prop _murder _rape _robbery _assault _burglary _larceny _auto _litigate _black _metrop _unemp _pris_tot _a??_??)
merge 1:1 state year using "C:\Users\David\Dropbox\Documents\Work\Library\Sentencing reform\Levitt 1996\Levitt-provided data", keep(master match) nogen
gen a00_14 = a0_4 + a5_14

* build stage indicators
recode y_* (. = 0)
foreach stage in file prel fina furt rele {
	by state: gen byte c`stage' = sum(y_`stage') // running sum
}
gen byte stage  = cond(crele, 6, cond(cfurt, 5, cond(cfina, 4, cond(cprel, 3, cond(cfile, 2, 1)))), .)                         
gen byte stage2 = cond(!litigate, 0, cond(stage==1, cond(F3.stage-1, 1, 0, .), cond(D.stage, 2, (LD.stage | L2D.stage)*3, .)))

label define stages  1 "Filing" 2 "Filing" 3 "Preliminary decision" 4 "Final decision" 5 "Later court action" 6 "Release by court", replace
label define stages2 0 "stable" 1 "in 1-3 years" 2 "last year" 3 "2-3 years ago", replace
label values stage  stages
label values stage2 stages2

* divide vars by population, take logs, first differences
foreach prefix in "" _ {
	gen double `prefix'incomepop = `prefix'income / `prefix'popul / `prefix'cpi * 4.201 // convert to 1992 $
	foreach var in pris_tot cri_viol murder rape assault robbery cri_prop burglary larceny auto police a00_14 a15_17 a18_24 a25_34 {
		cap noi gen double `prefix'`var'pop =  `prefix'`var' / `prefix'popul * 100 // per 100,000
	}

	foreach var in pris_totpop cri_violpop cri_proppop {
		gen double `prefix'D`var' = `prefix'`var' / L.`prefix'`var' - 1 // growth in prisoners/capita
		regress `prefix'D`var' i.year
		cap drop t
		predict double t, resid
		replace `prefix'D`var' = t * 100 // deviations from national average, to be displayed as percentages
	}
	gen double `prefix'FDcri_violpop = F.`prefix'Dcri_violpop
	gen double `prefix'FDcri_proppop = F.`prefix'Dcri_proppop
	foreach var in pris_totpop cri_violpop cri_proppop policepop incomepop {
		cap noi gen double `prefix'l`var' = ln(`prefix'`var')
	}
}
replace popul = popul / 1000000 // smaller values for weights sometimes improves numerical stability

// compare original & replication variables
foreach var of varlist _* {
	cap noi corr `var' `=substr("`var'", 2, .)' if year>1972 & year<=1993
	cap noi scatter `var' `=substr("`var'", 2, .)' if year>1972 & year<=1993, title(`var') name(`var', replace) mlab(label) mlabsize(tiny)
}
regress r_file i3.stage2#i2.stage, noheader
regress r_prel i3.stage2#i3.stage, noheader
regress r_fina i3.stage2#i4.stage, noheader
regress r_furt i3.stage2#i5.stage, noheader
regress r_rele i3.stage2#i6.stage, noheader


***
*** Levitt tables, approximately
***

* Table II
format %4.1f pris_totpop cri_violpop murderpop rapepop assaultpop robberypop cri_proppop burglarypop larcenypop autopop
format %4.3f stage policepop incomepop unemp black metrop a00_14pop a15_17pop a18_24pop a25_34pop
sum pris_totpop cri_violpop murderpop rapepop assaultpop robberypop cri_proppop burglarypop larcenypop autopop i.stage policepop incomepop unemp black metrop a00_14pop a15_17pop a18_24pop a25_34pop if year>=1971 & year<=1993, fvwrap(3) format

* Table III
table PostalCode stage if litigate & year>1972 & year<=1993, c(mean Dpris_totpop) row format(%3.1f)

* Table IV
table stage if litigate & year>1972 & year<=1993 & stage2, by(stage2) c(n Dpris_totpop mean Dpris_totpop mean FDcri_violpop mean FDcri_proppop) format(%3.1f)

* Table V
regress DL.lpris_totpop ibnL.stage#i(1/3)L.stage2 LD.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year         if year>1972+1 & year<=1993+1, robust
est store T5Prison
regress DL.lpris_totpop ibnL.stage#i(1/3)L.stage2 LD.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year i.state if year>1972+1 & year<=1993+1, robust
est store T5PrisonFE
regress  D.lcri_violpop ibnL.stage#i(1/3)L.stage2  D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year         if year>1972 & year<=1993, robust
est store T5Violent
regress  D.lcri_violpop ibnL.stage#i(1/3)L.stage2  D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year i.state if year>1972 & year<=1993, robust
est store T5ViolentFE
regress  D.lcri_proppop ibnL.stage#i(1/3)L.stage2  D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year         if year>1972 & year<=1993, robust
est store T5Property
regress  D.lcri_proppop ibnL.stage#i(1/3)L.stage2  D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year i.state if year>1972 & year<=1993, robust
est store T5PropertyFE
est tab T5*, se varwidth(30) modelwidth(12) b(%4.3f)

* Table VI
regress   D.lcri_violpop   DL.lpris_totpop                          D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year         if year>1972 & year<=1993, robust
est store T6ViolentOLS
ivreg2 D.lcri_violpop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year         if year>1972 & year<=1993, robust small
est store T6ViolentIV
ivreg2 D.lcri_violpop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year i.state if year>1972 & year<=1993, robust small
est store T6ViolentIVFE
regress   D.lcri_proppop   DL.lpris_totpop                          D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year         if year>1972 & year<=1993, robust
est store T6PropertyOLS
ivreg2 D.lcri_proppop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year         if year>1972 & year<=1993, robust small
est store T6PropertyIV
est tab T6*, keep(DL.lpris_totpop) se varwidth(30) modelwidth(10) b(%4.3f) stats(jp idp widstat)

* numbers used in text to estimate impacts in crimes/prisoner/year
sum pris_totpop cri_violpop cri_proppop [aw=popul] if e(sample)
di 1/186.7812 * -.379 *  582.9619 // violent crime
di 1/186.7812 * -.261 * 4802.446  // property crime

* show cross-state het in unweighted regressions
xi i.year i.state i.stage*i.stage2
qui ivreg2 D.lcri_proppop   (DL.lpris_totpop = _IstaXsta* _Istage*) D.( lincomepop  unemp  lpolicepop  metrop  black  a00_14pop  a15_17pop  a18_24pop  a25_34pop) _Iyear_1973-_Iyear_1992 _Istate*        if year>1972 & year<=1993, robust small
ivhettest _Istate* // cross-state het test



***
*** Roodman replication table & graphs
***

xi i.year i.state i.stage*i.stage2, noomit
drop _IstaXsta*0
global controls D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year i.state

outreg, clear(Results)
global outregcmd outreg, tdec(3) se starlevels(10 5 1) merge nodisplay rtitle("Per-capita prison growth" \ "") summtitle("Kleibergen-Paap underid. p" \ "Kleibergen-Paap F" \ "Hansen overid. p" \ "") summstat(idp \ widstat \ jp)

set seed 987654321
foreach dataset in Levitt New {
	foreach crime in viol prop {

		foreach wexp in "" [aw=popul] {
			outreg, clear
			ivreg2 D.lcri_`crime'pop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) $controls `wexp' if year>1972 & year<=1993, partial($controls) small robust
			$outregcmd keep(DL.lpris_totpop) ctitle("", "2SLS")
			ivreg2 D.lcri_`crime'pop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) $controls `wexp' if year>1972 & year<=1993, partial($controls) small cluster(state)
			$outregcmd keep(DL.lpris_totpop) ctitle("", "2SLS-cluster")                                                                          
			ivreg2 D.lcri_`crime'pop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) $controls `wexp' if year>1972 & year<=1993, partial($controls) small cluster(state) liml
			$outregcmd keep(DL.lpris_totpop) ctitle("", "LIML-cluster")

			 // Ackerberg & Devereux IJIVE: first partial exogenous controls out of everything else
			cap drop Y X Z*
			regress D.lcri_`crime'pop $controls `wexp' if e(sample)
			predict double Y if e(sample), resid
			regress DL.lpris_totpop   $controls `wexp' if e(sample)
			predict double X if e(sample), resid
			fvrevar ibnL.stage#i(1/3)L.stage2
			local i 0
			foreach var in `r(varlist)' {
				qui regress `var' $controls `wexp' if e(sample)
				predict double Z`++i' if e(sample), resid
			}
			cap drop JIV
			makejive `wexp' if e(sample), gen(JIV) cluster(state) instd(X) insts(Z*) nocons
			ivreg2 Y (X = JIV) if year>1972 & year<=1993, cluster(state) small nocons
			$outregcmd keep(X) ctitle("", "JIVE-cluster")

			outreg, append replay(Results) store(Results) nodisplay
		}

		* weakiv graphs by instrument
		global graphs
		local i 0
		foreach stagepair in "1 1" "2 2" "2 3" "3 2" "3 3" "4 2" "4 3" "5 2" "5 3" "6 2" "6 3" {
			local stage : word 1 of `stagepair'
			local stage2: word 2 of `stagepair'
			ivreg2 D.lcri_`crime'pop (DL.lpris_totpop = i`stage'L.stage#i`stage2'L.stage2) $controls [aw=popul] if year>1972 & year<=1993, cluster(state) small
			boottest, gridmin(-2) gridmax(2) gridpoints(100) level(100) ar graphname(`crime'`stage'`stage2', replace) ///
				graphopt( ///
					ytitle(`"`=cond(mod(`++i',3)==1,"p value","")'"') ///
					xtitle(`"`=cond(`i'>=10,"Impact elasticity","")'"') ///
					title("`i'. `:label (stage) `stage'' `:label (stage2) `stage2''", size(medium) span) ///
					ylabel(0(.1)1, angle(hor) labsize(small)) ///
					plotregion(margin(none)))
			if !_rc global graphs $graphs `crime'`stage'`stage2'
		}

		* A-R graphs with all instruments
		ivreg2 D.lcri_`crime'pop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) $controls [aw=popul] if year>1972 & year<=1993, cluster(state) small
		boottest, gridmin(-2) gridmax(2) gridpoints(100) level(100) ar graphname(`crime', replace) ///
			graphopt( ///
				ytitle("") ///
				xtitle("Impact elasticity") ///
				title("12. All", size(medium) span) ///
				ylabel(0(.1)1, angle(hor) labsize(small)) ///
				plotregion(margin(none)))
		graph export "Levitt `crime' AR all `dataset'.png", replace width(1000)
		graph combine $graphs `crime', xcommon ycommon name(`crime'AR`dataset', replace) cols(3) graphregion(margin(none)) xsize(6.5) ysize(8)
		graph export "Levitt `crime' AR `dataset'.png", replace width(1000)

		* A-R graphs with most-signficant instruments only--not used in text
		regress DL.lpris_totpop _IstaXsta* $controls [aw=popul] if year>1972 & year<=1993 & D.lcri_violpop<., cluster(state)
		mata st_global("insts", invtokens(st_matrixcolstripe("e(b)")[selectindex(-abs(st_matrix("e(b)")':/sqrt(diagonal(st_matrix("e(V)"))))[|1\18|]:<-1.68),2]')) // those with |t|>1.68
		local subtitle
		foreach var in $insts {
			tokenize "`var'", parse("_")
			local t `:label (stage) `4'' `:label (stage2) `6''
			local subtitle = cond("`subtitle'"=="", "`t'", "`subtitle'; " + lower("`t'"))
		}
		ivreg2 D.lcri_`crime'pop (DL.lpris_totpop = $insts) $controls [aw=popul] if year>1972 & year<=1993, cluster(state) small
		boottest, gridmin(-2) gridmax(2) gridpoints(100) level(100) ar graphname(`crime'`dataset'subset, replace) ///
			graphopt( ///
				ytitle("") ///
				xtitle("Impact elasticity") ///
				title(`"`dataset' data, `=cond("`crime'"=="viol","violent","property")' crime"', size(medium) span) ///
				subtitle("`subtitle'", size(small) span) ///
				ylabel(0(.1)1, angle(hor) labsize(small)) ///
				plotregion(margin(none)))
	}

	* serial correlation test in weighted regressions
	qui ivreg2 D.lcri_violpop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) $controls [aw=popul] if year>1972 & year<=1993, small robust
	abar, lags(20)
	qui ivreg2 D.lcri_proppop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) $controls [aw=popul] if year>1972 & year<=1993, small robust
	abar, lags(20)
	
	* swap data sets
	ren (_popul _pris_tot _unemp _police _cpi _cri_viol _cri_prop _murder _rape _robbery _assault _burglary _larceny _auto _income _black _a00_14 _a15_17 _a18_24 _a25_34 _litigate _metrop _incomepop _pris_totpop _cri_violpop _murderpop _rapepop _assaultpop _robberypop _cri_proppop _burglarypop _larcenypop _autopop _a00_14pop _a15_17pop _a18_24pop _a25_34pop _Dpris_totpop _Dcri_violpop _Dcri_proppop _FDcri_violpop _FDcri_proppop _lpris_totpop _lcri_violpop _lcri_proppop _lincomepop  popul  pris_tot  unemp  cpi  police  cri_viol  cri_prop  murder  rape  robbery  assault  burglary  larceny  auto  income  black  a00_14  a15_17  a18_24  a25_34  litigate  metrop  incomepop  pris_totpop  cri_violpop  murderpop  rapepop  assaultpop  robberypop  cri_proppop  burglarypop  larcenypop  autopop  a00_14pop  a15_17pop  a18_24pop  a25_34pop  Dpris_totpop  Dcri_violpop  Dcri_proppop  FDcri_violpop  FDcri_proppop  lpris_totpop  lcri_violpop  lcri_proppop  lincomepop)  ///
	    ( popul  pris_tot  unemp  police  cpi  cri_viol  cri_prop  murder  rape  robbery  assault  burglary  larceny  auto  income  black  a00_14  a15_17  a18_24  a25_34  litigate  metrop  incomepop  pris_totpop  cri_violpop  murderpop  rapepop  assaultpop  robberypop  cri_proppop  burglarypop  larcenypop  autopop  a00_14pop  a15_17pop  a18_24pop  a25_34pop  Dpris_totpop  Dcri_violpop  Dcri_proppop  FDcri_violpop  FDcri_proppop  lpris_totpop  lcri_violpop  lcri_proppop  lincomepop _popul _pris_tot _unemp _cpi _police _cri_viol _cri_prop _murder _rape _robbery _assault _burglary _larceny _auto _income _black _a00_14 _a15_17 _a18_24 _a25_34 _litigate _metrop _incomepop _pris_totpop _cri_violpop _murderpop _rapepop _assaultpop _robberypop _cri_proppop _burglarypop _larcenypop _autopop _a00_14pop _a15_17pop _a18_24pop _a25_34pop _Dpris_totpop _Dcri_violpop _Dcri_proppop _FDcri_violpop _FDcri_proppop _lpris_totpop _lcri_violpop _lcri_proppop _lincomepop)
}
graph combine violLevittsubset propLevittsubset violNewsubset propNewsubset, cols(2) graphregion(margin(none)) xsize(6.5) name(subset, replace)
graph export "Levitt AR subset.png", replace width(1000)

outreg using "Levitt replication", replace replay(Results) note("Standard errors in parentheses, heteroskedasticity-robust in first column, Newey-West with 5-year bandwidth in rest. *Significant at p<0.1. **Significant at p<0.05. ***Significant at p<0.01.")

----
* weakiv demo, ideal case
clear
set obs 1000000
set seed 987654321
drawnorm z e1 e2
gen x = z + e1 + e2
gen y = x + e2
ivregress 2sls y (x=z)
weakiv, graph(ar) gridmin(.99601) gridmax(1.00299) ///
	graphopt( ///
		yscale(reverse) lcolor(dkgreen) ///
		ytitle("") ///
		ylabel(0 "1" .1 ".9" .2 ".8" .3 ".7" .4 ".6" .5 ".5" .6 ".4" .7 ".3" .8 ".2" .9 ".1" 1 "0", angle(hor) labsize(small)) ///
		xlabel(.998 1 1.002) ///
		plotregion(margin(none)) graphregion(margin(0 0 1 1)))
graph export "Levitt AR demo.png", replace width(1000)

-----
* journal graphs
set seed 987654321
set scheme s1color

ivreg2 D.lcri_violpop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year i.state [aw=popul] if year>1972 & year<=1993, cluster(state) small
boottest, ar gridmin(-2) gridmax(2) gridpoints(100) level(100) graphname(g1, replace) ///
	graphopt(lcolor(blue) ytitle("Levitt data set", size(huge)) yline(.05) title("Violent crime", size(huge)) ylabel(0(.1)1, angle(hor) labsize(medium)) xlabel("") graphregion(margin(small)) plotregion(margin(none)))

ivreg2 D.lcri_proppop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year i.state [aw=popul] if year>1972 & year<=1993, cluster(state) small
boottest, ar gridmin(-2) gridmax(2) gridpoints(100) level(100) graphname(g2, replace) ///
	graphopt(lcolor(blue) ytitle("") yline(.05) title("Property crime", size(huge)) ylabel("") yscale(range(0 1)) xlabel("") graphregion(margin(small)) plotregion(margin(none)))

ren (_popul _pris_tot _unemp _police _cpi _cri_viol _cri_prop _murder _rape _robbery _assault _burglary _larceny _auto _income _black _a00_14 _a15_17 _a18_24 _a25_34 _litigate _metrop _incomepop _pris_totpop _cri_violpop _murderpop _rapepop _assaultpop _robberypop _cri_proppop _burglarypop _larcenypop _autopop _a00_14pop _a15_17pop _a18_24pop _a25_34pop _Dpris_totpop _Dcri_violpop _Dcri_proppop _FDcri_violpop _FDcri_proppop _lpris_totpop _lcri_violpop _lcri_proppop _lincomepop  popul  pris_tot  unemp  cpi  police  cri_viol  cri_prop  murder  rape  robbery  assault  burglary  larceny  auto  income  black  a00_14  a15_17  a18_24  a25_34  litigate  metrop  incomepop  pris_totpop  cri_violpop  murderpop  rapepop  assaultpop  robberypop  cri_proppop  burglarypop  larcenypop  autopop  a00_14pop  a15_17pop  a18_24pop  a25_34pop  Dpris_totpop  Dcri_violpop  Dcri_proppop  FDcri_violpop  FDcri_proppop  lpris_totpop  lcri_violpop  lcri_proppop  lincomepop)  ///
		( popul  pris_tot  unemp  police  cpi  cri_viol  cri_prop  murder  rape  robbery  assault  burglary  larceny  auto  income  black  a00_14  a15_17  a18_24  a25_34  litigate  metrop  incomepop  pris_totpop  cri_violpop  murderpop  rapepop  assaultpop  robberypop  cri_proppop  burglarypop  larcenypop  autopop  a00_14pop  a15_17pop  a18_24pop  a25_34pop  Dpris_totpop  Dcri_violpop  Dcri_proppop  FDcri_violpop  FDcri_proppop  lpris_totpop  lcri_violpop  lcri_proppop  lincomepop _popul _pris_tot _unemp _cpi _police _cri_viol _cri_prop _murder _rape _robbery _assault _burglary _larceny _auto _income _black _a00_14 _a15_17 _a18_24 _a25_34 _litigate _metrop _incomepop _pris_totpop _cri_violpop _murderpop _rapepop _assaultpop _robberypop _cri_proppop _burglarypop _larcenypop _autopop _a00_14pop _a15_17pop _a18_24pop _a25_34pop _Dpris_totpop _Dcri_violpop _Dcri_proppop _FDcri_violpop _FDcri_proppop _lpris_totpop _lcri_violpop _lcri_proppop _lincomepop)

ivreg2 D.lcri_violpop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year i.state [aw=popul] if year>1972 & year<=1993, cluster(state) small
boottest, ar gridmin(-2) gridmax(2) gridpoints(100) level(100) graphname(g3, replace) ///
	graphopt(lcolor(blue) ytitle("New data set", size(huge)) yline(.05) xtitle("Impact elasticity", size(huge)) ylabel(0(.1)1, angle(hor) labsize(medium)) graphregion(margin(small)) plotregion(margin(none)))

ivreg2 D.lcri_proppop (DL.lpris_totpop = ibnL.stage#i(1/3)L.stage2) D.(lincomepop unemp lpolicepop metrop black a00_14pop a15_17pop a18_24pop a25_34pop) i.year i.state [aw=popul] if year>1972 & year<=1993, cluster(state) small
boottest, ar gridmin(-2) gridmax(2) gridpoints(100) level(100) graphname(g4, replace) ///
	graphopt(lcolor(blue) ytitle("") yline(.05) xtitle("Impact elasticity", size(huge)) ylabel("") yscale(range(0 1)) graphregion(margin(small)) plotregion(margin(none)))

ren (_popul _pris_tot _unemp _police _cpi _cri_viol _cri_prop _murder _rape _robbery _assault _burglary _larceny _auto _income _black _a00_14 _a15_17 _a18_24 _a25_34 _litigate _metrop _incomepop _pris_totpop _cri_violpop _murderpop _rapepop _assaultpop _robberypop _cri_proppop _burglarypop _larcenypop _autopop _a00_14pop _a15_17pop _a18_24pop _a25_34pop _Dpris_totpop _Dcri_violpop _Dcri_proppop _FDcri_violpop _FDcri_proppop _lpris_totpop _lcri_violpop _lcri_proppop _lincomepop  popul  pris_tot  unemp  cpi  police  cri_viol  cri_prop  murder  rape  robbery  assault  burglary  larceny  auto  income  black  a00_14  a15_17  a18_24  a25_34  litigate  metrop  incomepop  pris_totpop  cri_violpop  murderpop  rapepop  assaultpop  robberypop  cri_proppop  burglarypop  larcenypop  autopop  a00_14pop  a15_17pop  a18_24pop  a25_34pop  Dpris_totpop  Dcri_violpop  Dcri_proppop  FDcri_violpop  FDcri_proppop  lpris_totpop  lcri_violpop  lcri_proppop  lincomepop)  ///
		( popul  pris_tot  unemp  police  cpi  cri_viol  cri_prop  murder  rape  robbery  assault  burglary  larceny  auto  income  black  a00_14  a15_17  a18_24  a25_34  litigate  metrop  incomepop  pris_totpop  cri_violpop  murderpop  rapepop  assaultpop  robberypop  cri_proppop  burglarypop  larcenypop  autopop  a00_14pop  a15_17pop  a18_24pop  a25_34pop  Dpris_totpop  Dcri_violpop  Dcri_proppop  FDcri_violpop  FDcri_proppop  lpris_totpop  lcri_violpop  lcri_proppop  lincomepop _popul _pris_tot _unemp _cpi _police _cri_viol _cri_prop _murder _rape _robbery _assault _burglary _larceny _auto _income _black _a00_14 _a15_17 _a18_24 _a25_34 _litigate _metrop _incomepop _pris_totpop _cri_violpop _murderpop _rapepop _assaultpop _robberypop _cri_proppop _burglarypop _larcenypop _autopop _a00_14pop _a15_17pop _a18_24pop _a25_34pop _Dpris_totpop _Dcri_violpop _Dcri_proppop _FDcri_violpop _FDcri_proppop _lpris_totpop _lcri_violpop _lcri_proppop _lincomepop)

graph combine g1 g2 g3 g4, graphregion(margin(none))
graph export "Levitt journal.png", replace width(1000)
